/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.HeaderBehavior;
import android.support.design.widget.HeaderScrollingViewBehavior;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ThemeUtils;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewUtils;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class AppBarLayout
extends LinearLayout {
    private static final int PENDING_ACTION_NONE = 0;
    private static final int PENDING_ACTION_EXPANDED = 1;
    private static final int PENDING_ACTION_COLLAPSED = 2;
    private static final int PENDING_ACTION_ANIMATE_ENABLED = 4;
    private static final int INVALID_SCROLL_RANGE = -1;
    private int mTotalScrollRange = -1;
    private int mDownPreScrollRange = -1;
    private int mDownScrollRange = -1;
    boolean mHaveChildWithInterpolator;
    private float mTargetElevation;
    private int mPendingAction = 0;
    private WindowInsetsCompat mLastInsets;
    private final List<OnOffsetChangedListener> mListeners;

    public AppBarLayout(Context context) {
        this(context, null);
    }

    public AppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        ThemeUtils.checkAppCompatTheme(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AppBarLayout, 0, R.style.Widget_Design_AppBarLayout);
        this.mTargetElevation = a.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0);
        this.setBackgroundDrawable(a.getDrawable(R.styleable.AppBarLayout_android_background));
        if (a.hasValue(R.styleable.AppBarLayout_expanded)) {
            this.setExpanded(a.getBoolean(R.styleable.AppBarLayout_expanded, false));
        }
        a.recycle();
        ViewUtils.setBoundsViewOutlineProvider((View)this);
        this.mListeners = new ArrayList<OnOffsetChangedListener>();
        ViewCompat.setElevation((View)this, (float)this.mTargetElevation);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                AppBarLayout.this.setWindowInsets(insets);
                return insets.consumeSystemWindowInsets();
            }
        });
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener listener) {
        if (listener != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.invalidateScrollRanges();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.invalidateScrollRanges();
        this.mHaveChildWithInterpolator = false;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.mHaveChildWithInterpolator = true;
            break;
        }
    }

    private void invalidateScrollRanges() {
        this.mTotalScrollRange = -1;
        this.mDownPreScrollRange = -1;
        this.mDownScrollRange = -1;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, ViewCompat.isLaidOut((View)this));
    }

    public void setExpanded(boolean expanded, boolean animate) {
        this.mPendingAction = (expanded ? 1 : 2) | (animate ? 4 : 0);
        this.requestLayout();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    private boolean hasChildWithInterpolator() {
        return this.mHaveChildWithInterpolator;
    }

    public final int getTotalScrollRange() {
        if (this.mTotalScrollRange != -1) {
            return this.mTotalScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight + lp.topMargin + lp.bottomMargin;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        this.mTotalScrollRange = Math.max(0, range - this.getTopInset());
        return this.mTotalScrollRange;
    }

    private boolean hasScrollableChildren() {
        return this.getTotalScrollRange() != 0;
    }

    private int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    private int getDownNestedPreScrollRange() {
        if (this.mDownPreScrollRange != -1) {
            return this.mDownPreScrollRange;
        }
        int range = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 5) == 5) {
                range += lp.topMargin + lp.bottomMargin;
                if ((flags & 8) != 0) {
                    range += ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                range += childHeight;
                continue;
            }
            if (range > 0) break;
        }
        this.mDownPreScrollRange = range;
        return this.mDownPreScrollRange;
    }

    private int getDownNestedScrollRange() {
        if (this.mDownScrollRange != -1) {
            return this.mDownScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            childHeight += lp.topMargin + lp.bottomMargin;
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child) + this.getTopInset();
            break;
        }
        this.mDownScrollRange = Math.max(0, range);
        return this.mDownScrollRange;
    }

    final int getMinimumHeightForVisibleOverlappingContent() {
        int topInset = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight != 0) {
            return minHeight * 2 + topInset;
        }
        int childCount = this.getChildCount();
        return childCount >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(childCount - 1)) * 2 + topInset : 0;
    }

    public void setTargetElevation(float elevation) {
        this.mTargetElevation = elevation;
    }

    public float getTargetElevation() {
        return this.mTargetElevation;
    }

    private int getPendingAction() {
        return this.mPendingAction;
    }

    private void resetPendingAction() {
        this.mPendingAction = 0;
    }

    private int getTopInset() {
        return this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
    }

    private void setWindowInsets(WindowInsetsCompat insets) {
        View child;
        this.mTotalScrollRange = -1;
        this.mLastInsets = insets;
        int z = this.getChildCount();
        for (int i = 0; i < z && !(insets = ViewCompat.dispatchApplyWindowInsets((View)(child = this.getChildAt(i)), (WindowInsetsCompat)insets)).isConsumed(); ++i) {
        }
    }

    public static class ScrollingViewBehavior
    extends HeaderScrollingViewBehavior {
        private int mOverlayTop;

        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollingViewBehavior_Params);
            this.mOverlayTop = a.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Params_behavior_overlapTop, 0);
            a.recycle();
        }

        @Override
        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency instanceof AppBarLayout;
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, View child, int layoutDirection) {
            super.onLayoutChild(parent, child, layoutDirection);
            List<View> dependencies = parent.getDependencies(child);
            int z = dependencies.size();
            for (int i = 0; i < z && !this.updateOffset(parent, child, dependencies.get(i)); ++i) {
            }
            return true;
        }

        @Override
        public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
            this.updateOffset(parent, child, dependency);
            return false;
        }

        private boolean updateOffset(CoordinatorLayout parent, View child, View dependency) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)dependency.getLayoutParams()).getBehavior();
            if (behavior instanceof Behavior) {
                int offset = ((Behavior)behavior).getTopBottomOffsetForScrollingSibling();
                this.setTopAndBottomOffset(dependency.getHeight() + offset - this.getOverlapForOffset(dependency, offset));
                return true;
            }
            return false;
        }

        private int getOverlapForOffset(View dependency, int offset) {
            if (this.mOverlayTop != 0 && dependency instanceof AppBarLayout) {
                AppBarLayout abl = (AppBarLayout)dependency;
                int totalScrollRange = abl.getTotalScrollRange();
                int preScrollDown = abl.getDownNestedPreScrollRange();
                if (preScrollDown != 0 && totalScrollRange + offset <= preScrollDown) {
                    return 0;
                }
                int availScrollRange = totalScrollRange - preScrollDown;
                if (availScrollRange != 0) {
                    float percScrolled = (float)offset / (float)availScrollRange;
                    return MathUtils.constrain(Math.round((1.0f + percScrolled) * (float)this.mOverlayTop), 0, this.mOverlayTop);
                }
            }
            return this.mOverlayTop;
        }

        public void setOverlayTop(int overlayTop) {
            this.mOverlayTop = overlayTop;
        }

        public int getOverlayTop() {
            return this.mOverlayTop;
        }

        @Override
        View findFirstDependency(List<View> views) {
            int z = views.size();
            for (int i = 0; i < z; ++i) {
                View view = views.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return view;
            }
            return null;
        }

        @Override
        int getScrollRange(View v) {
            if (v instanceof AppBarLayout) {
                return ((AppBarLayout)v).getTotalScrollRange();
            }
            return super.getScrollRange(v);
        }
    }

    public static class Behavior
    extends HeaderBehavior<AppBarLayout> {
        private static final int ANIMATE_OFFSET_DIPS_PER_SECOND = 300;
        private static final int INVALID_POSITION = -1;
        private int mOffsetDelta;
        private boolean mSkipNestedPreScroll;
        private boolean mWasFlung;
        private ValueAnimatorCompat mAnimator;
        private int mOffsetToChildIndexOnLayout = -1;
        private boolean mOffsetToChildIndexOnLayoutIsMinHeight;
        private float mOffsetToChildIndexOnLayoutPerc;
        private WeakReference<View> mLastNestedScrollingChildRef;
        private DragCallback mOnDragCallback;

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        @Override
        public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
            boolean started;
            boolean bl = started = (nestedScrollAxes & 2) != 0 && child.hasScrollableChildren() && parent.getHeight() - directTargetChild.getHeight() <= child.getHeight();
            if (started && this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            this.mLastNestedScrollingChildRef = null;
            return started;
        }

        @Override
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dx, int dy, int[] consumed) {
            if (dy != 0 && !this.mSkipNestedPreScroll) {
                int max;
                int min;
                if (dy < 0) {
                    min = -child.getTotalScrollRange();
                    max = min + child.getDownNestedPreScrollRange();
                } else {
                    min = -child.getUpNestedPreScrollRange();
                    max = 0;
                }
                consumed[1] = this.scroll(coordinatorLayout, child, dy, min, max);
            }
        }

        @Override
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (dyUnconsumed < 0) {
                this.scroll(coordinatorLayout, child, dyUnconsumed, -child.getDownNestedScrollRange(), 0);
                this.mSkipNestedPreScroll = true;
            } else {
                this.mSkipNestedPreScroll = false;
            }
        }

        @Override
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout abl, View target) {
            if (!this.mWasFlung) {
                this.snapToChildIfNeeded(coordinatorLayout, abl);
            }
            this.mSkipNestedPreScroll = false;
            this.mWasFlung = false;
            this.mLastNestedScrollingChildRef = new WeakReference<View>(target);
        }

        @Override
        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY, boolean consumed) {
            boolean flung = false;
            if (!consumed) {
                flung = this.fling(coordinatorLayout, child, -child.getTotalScrollRange(), 0, -velocityY);
            } else if (velocityY < 0.0f) {
                int targetScroll = -child.getTotalScrollRange() + child.getDownNestedPreScrollRange();
                if (this.getTopBottomOffsetForScrollingSibling() < targetScroll) {
                    this.animateOffsetTo(coordinatorLayout, child, targetScroll);
                    flung = true;
                }
            } else {
                int targetScroll = -child.getUpNestedPreScrollRange();
                if (this.getTopBottomOffsetForScrollingSibling() > targetScroll) {
                    this.animateOffsetTo(coordinatorLayout, child, targetScroll);
                    flung = true;
                }
            }
            this.mWasFlung = flung;
            return flung;
        }

        public void setDragCallback(@Nullable DragCallback callback) {
            this.mOnDragCallback = callback;
        }

        private void animateOffsetTo(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset) {
            int currentOffset = this.getTopBottomOffsetForScrollingSibling();
            if (currentOffset == offset) {
                if (this.mAnimator != null && this.mAnimator.isRunning()) {
                    this.mAnimator.cancel();
                }
                return;
            }
            if (this.mAnimator == null) {
                this.mAnimator = ViewUtils.createAnimator();
                this.mAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
                this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        Behavior.this.setHeaderTopBottomOffset(coordinatorLayout, child, animator.getAnimatedIntValue());
                    }
                });
            } else {
                this.mAnimator.cancel();
            }
            float distanceDp = (float)Math.abs(currentOffset - offset) / coordinatorLayout.getResources().getDisplayMetrics().density;
            this.mAnimator.setDuration(Math.round(distanceDp * 1000.0f / 300.0f));
            this.mAnimator.setIntValues(currentOffset, offset);
            this.mAnimator.start();
        }

        private View getChildOnOffset(AppBarLayout abl, int offset) {
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                if (child.getTop() > -offset || child.getBottom() < -offset) continue;
                return child;
            }
            return null;
        }

        private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, AppBarLayout abl) {
            LayoutParams lp;
            int offset = this.getTopBottomOffsetForScrollingSibling();
            View offsetChild = this.getChildOnOffset(abl, offset);
            if (offsetChild != null && ((lp = (LayoutParams)offsetChild.getLayoutParams()).getScrollFlags() & 0x11) == 17) {
                int childTop = -offsetChild.getTop();
                int childBottom = -offsetChild.getBottom();
                if ((lp.getScrollFlags() & 2) == 2) {
                    childBottom += ViewCompat.getMinimumHeight((View)offsetChild);
                }
                int newOffset = offset < (childBottom + childTop) / 2 ? childBottom : childTop;
                this.animateOffsetTo(coordinatorLayout, abl, MathUtils.constrain(newOffset, -abl.getTotalScrollRange(), 0));
            }
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, AppBarLayout abl, int layoutDirection) {
            boolean handled = super.onLayoutChild(parent, abl, layoutDirection);
            int pendingAction = abl.getPendingAction();
            if (pendingAction != 0) {
                boolean animate;
                boolean bl = animate = (pendingAction & 4) != 0;
                if ((pendingAction & 2) != 0) {
                    int offset = -abl.getUpNestedPreScrollRange();
                    if (animate) {
                        this.animateOffsetTo(parent, abl, offset);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, offset);
                    }
                } else if ((pendingAction & 1) != 0) {
                    if (animate) {
                        this.animateOffsetTo(parent, abl, 0);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, 0);
                    }
                }
            } else if (this.mOffsetToChildIndexOnLayout >= 0) {
                View child = abl.getChildAt(this.mOffsetToChildIndexOnLayout);
                int offset = -child.getBottom();
                offset = this.mOffsetToChildIndexOnLayoutIsMinHeight ? (offset += ViewCompat.getMinimumHeight((View)child)) : (offset += Math.round((float)child.getHeight() * this.mOffsetToChildIndexOnLayoutPerc));
                this.setTopAndBottomOffset(offset);
            }
            abl.resetPendingAction();
            this.mOffsetToChildIndexOnLayout = -1;
            this.dispatchOffsetUpdates(abl);
            return handled;
        }

        @Override
        boolean canDragView(AppBarLayout view) {
            if (this.mOnDragCallback != null) {
                return this.mOnDragCallback.canDrag(view);
            }
            if (this.mLastNestedScrollingChildRef != null) {
                View scrollingView = (View)this.mLastNestedScrollingChildRef.get();
                return scrollingView != null && scrollingView.isShown() && !ViewCompat.canScrollVertically((View)scrollingView, (int)-1);
            }
            return true;
        }

        @Override
        int getMaxDragOffset(AppBarLayout view) {
            return -view.getDownNestedScrollRange();
        }

        @Override
        int getScrollRangeForDragFling(AppBarLayout view) {
            return view.getTotalScrollRange();
        }

        @Override
        int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout header, int newOffset, int minOffset, int maxOffset) {
            int curOffset = this.getTopBottomOffsetForScrollingSibling();
            int consumed = 0;
            if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset) {
                newOffset = MathUtils.constrain(newOffset, minOffset, maxOffset);
                AppBarLayout appBarLayout = header;
                if (curOffset != newOffset) {
                    int interpolatedOffset = appBarLayout.hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                    boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                    consumed = curOffset - newOffset;
                    this.mOffsetDelta = newOffset - interpolatedOffset;
                    if (!offsetChanged && appBarLayout.hasChildWithInterpolator()) {
                        coordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
                    }
                    this.dispatchOffsetUpdates(appBarLayout);
                }
            }
            return consumed;
        }

        private void dispatchOffsetUpdates(AppBarLayout layout2) {
            List listeners = layout2.mListeners;
            int z = listeners.size();
            for (int i = 0; i < z; ++i) {
                OnOffsetChangedListener listener = (OnOffsetChangedListener)listeners.get(i);
                if (listener == null) continue;
                listener.onOffsetChanged(layout2, this.getTopAndBottomOffset());
            }
        }

        private int interpolateOffset(AppBarLayout layout2, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout2.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout2.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                Interpolator interpolator = childLp.getScrollInterpolator();
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                if (interpolator == null) break;
                int childScrollableHeight = 0;
                int flags = childLp.getScrollFlags();
                if ((flags & 1) != 0) {
                    childScrollableHeight += child.getHeight() + childLp.topMargin + childLp.bottomMargin;
                    if ((flags & 2) != 0) {
                        childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                    }
                }
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    childScrollableHeight -= layout2.getTopInset();
                }
                if (childScrollableHeight <= 0) break;
                int offsetForView = absOffset - child.getTop();
                int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
                return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
            }
            return offset;
        }

        @Override
        int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.mOffsetDelta;
        }

        @Override
        public Parcelable onSaveInstanceState(CoordinatorLayout parent, AppBarLayout appBarLayout) {
            Parcelable superState = super.onSaveInstanceState(parent, appBarLayout);
            int offset = this.getTopAndBottomOffset();
            int count = appBarLayout.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = appBarLayout.getChildAt(i);
                int visBottom = child.getBottom() + offset;
                if (child.getTop() + offset > 0 || visBottom < 0) continue;
                SavedState ss = new SavedState(superState);
                ss.firstVisibleChildIndex = i;
                ss.firstVisibileChildAtMinimumHeight = visBottom == ViewCompat.getMinimumHeight((View)child);
                ss.firstVisibileChildPercentageShown = (float)visBottom / (float)child.getHeight();
                return ss;
            }
            return superState;
        }

        @Override
        public void onRestoreInstanceState(CoordinatorLayout parent, AppBarLayout appBarLayout, Parcelable state) {
            if (state instanceof SavedState) {
                SavedState ss = (SavedState)state;
                super.onRestoreInstanceState(parent, appBarLayout, ss.getSuperState());
                this.mOffsetToChildIndexOnLayout = ss.firstVisibleChildIndex;
                this.mOffsetToChildIndexOnLayoutPerc = ss.firstVisibileChildPercentageShown;
                this.mOffsetToChildIndexOnLayoutIsMinHeight = ss.firstVisibileChildAtMinimumHeight;
            } else {
                super.onRestoreInstanceState(parent, appBarLayout, state);
                this.mOffsetToChildIndexOnLayout = -1;
            }
        }

        protected static class SavedState
        extends View.BaseSavedState {
            int firstVisibleChildIndex;
            float firstVisibileChildPercentageShown;
            boolean firstVisibileChildAtMinimumHeight;
            public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

                public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                    return new SavedState(source, loader);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            });

            public SavedState(Parcel source, ClassLoader loader) {
                super(source);
                this.firstVisibleChildIndex = source.readInt();
                this.firstVisibileChildPercentageShown = source.readFloat();
                this.firstVisibileChildAtMinimumHeight = source.readByte() != 0;
            }

            public SavedState(Parcelable superState) {
                super(superState);
            }

            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.firstVisibleChildIndex);
                dest.writeFloat(this.firstVisibileChildPercentageShown);
                dest.writeByte((byte)(this.firstVisibileChildAtMinimumHeight ? 1 : 0));
            }
        }

        public static abstract class DragCallback {
            public abstract boolean canDrag(@NonNull AppBarLayout var1);
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        public static final int SCROLL_FLAG_SNAP = 16;
        static final int FLAG_QUICK_RETURN = 5;
        static final int FLAG_SNAP = 17;
        int mScrollFlags = 1;
        Interpolator mScrollInterpolator;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AppBarLayout_LayoutParams);
            this.mScrollFlags = a.getInt(R.styleable.AppBarLayout_LayoutParams_layout_scrollFlags, 0);
            if (a.hasValue(R.styleable.AppBarLayout_LayoutParams_layout_scrollInterpolator)) {
                int resId = a.getResourceId(R.styleable.AppBarLayout_LayoutParams_layout_scrollInterpolator, 0);
                this.mScrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)c, (int)resId);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((LinearLayout.LayoutParams)source);
            this.mScrollFlags = source.mScrollFlags;
            this.mScrollInterpolator = source.mScrollInterpolator;
        }

        public void setScrollFlags(int flags) {
            this.mScrollFlags = flags;
        }

        public int getScrollFlags() {
            return this.mScrollFlags;
        }

        public void setScrollInterpolator(Interpolator interpolator) {
            this.mScrollInterpolator = interpolator;
        }

        public Interpolator getScrollInterpolator() {
            return this.mScrollInterpolator;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScrollFlags {
        }
    }

    public static interface OnOffsetChangedListener {
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }
}

