/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityWindowInfoCompatApi21;

public class AccessibilityWindowInfoCompat {
    private static final AccessibilityWindowInfoImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new AccessibilityWindowInfoApi21Impl() : new AccessibilityWindowInfoStubImpl();
    private Object mInfo;
    private static final int UNDEFINED = -1;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_INPUT_METHOD = 2;
    public static final int TYPE_SYSTEM = 3;
    public static final int TYPE_ACCESSIBILITY_OVERLAY = 4;

    static AccessibilityWindowInfoCompat wrapNonNullInstance(Object object) {
        if (object != null) {
            return new AccessibilityWindowInfoCompat(object);
        }
        return null;
    }

    private AccessibilityWindowInfoCompat(Object info) {
        this.mInfo = info;
    }

    public int getType() {
        return IMPL.getType(this.mInfo);
    }

    public int getLayer() {
        return IMPL.getLayer(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getRoot() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getRoot(this.mInfo));
    }

    public AccessibilityWindowInfoCompat getParent() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public int getId() {
        return IMPL.getId(this.mInfo);
    }

    public void getBoundsInScreen(Rect outBounds) {
        IMPL.getBoundsInScreen(this.mInfo, outBounds);
    }

    public boolean isActive() {
        return IMPL.isActive(this.mInfo);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public AccessibilityWindowInfoCompat getChild(int index) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, index));
    }

    public static AccessibilityWindowInfoCompat obtain() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityWindowInfoCompat obtain(AccessibilityWindowInfoCompat info) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain(info.mInfo));
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    public int hashCode() {
        return this.mInfo == null ? 0 : this.mInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityWindowInfoCompat other = (AccessibilityWindowInfoCompat)obj;
        return !(this.mInfo == null ? other.mInfo != null : !this.mInfo.equals(other.mInfo));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Rect bounds = new Rect();
        this.getBoundsInScreen(bounds);
        builder.append("AccessibilityWindowInfo[");
        builder.append("id=").append(this.getId());
        builder.append(", type=").append(AccessibilityWindowInfoCompat.typeToString(this.getType()));
        builder.append(", layer=").append(this.getLayer());
        builder.append(", bounds=").append(bounds);
        builder.append(", focused=").append(this.isFocused());
        builder.append(", active=").append(this.isActive());
        builder.append(", hasParent=").append(this.getParent() != null);
        builder.append(", hasChildren=").append(this.getChildCount() > 0);
        builder.append(']');
        return builder.toString();
    }

    private static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "TYPE_APPLICATION";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 3: {
                return "TYPE_SYSTEM";
            }
            case 4: {
                return "TYPE_ACCESSIBILITY_OVERLAY";
            }
        }
        return "<UNKNOWN>";
    }

    private static class AccessibilityWindowInfoApi21Impl
    extends AccessibilityWindowInfoStubImpl {
        private AccessibilityWindowInfoApi21Impl() {
        }

        @Override
        public Object obtain() {
            return AccessibilityWindowInfoCompatApi21.obtain();
        }

        @Override
        public Object obtain(Object info) {
            return AccessibilityWindowInfoCompatApi21.obtain((Object)info);
        }

        @Override
        public int getType(Object info) {
            return AccessibilityWindowInfoCompatApi21.getType((Object)info);
        }

        @Override
        public int getLayer(Object info) {
            return AccessibilityWindowInfoCompatApi21.getLayer((Object)info);
        }

        @Override
        public Object getRoot(Object info) {
            return AccessibilityWindowInfoCompatApi21.getRoot((Object)info);
        }

        @Override
        public Object getParent(Object info) {
            return AccessibilityWindowInfoCompatApi21.getParent((Object)info);
        }

        @Override
        public int getId(Object info) {
            return AccessibilityWindowInfoCompatApi21.getId((Object)info);
        }

        @Override
        public void getBoundsInScreen(Object info, Rect outBounds) {
            AccessibilityWindowInfoCompatApi21.getBoundsInScreen((Object)info, (Rect)outBounds);
        }

        @Override
        public boolean isActive(Object info) {
            return AccessibilityWindowInfoCompatApi21.isActive((Object)info);
        }

        @Override
        public boolean isFocused(Object info) {
            return AccessibilityWindowInfoCompatApi21.isFocused((Object)info);
        }

        @Override
        public boolean isAccessibilityFocused(Object info) {
            return AccessibilityWindowInfoCompatApi21.isAccessibilityFocused((Object)info);
        }

        @Override
        public int getChildCount(Object info) {
            return AccessibilityWindowInfoCompatApi21.getChildCount((Object)info);
        }

        @Override
        public Object getChild(Object info, int index) {
            return AccessibilityWindowInfoCompatApi21.getChild((Object)info, (int)index);
        }

        @Override
        public void recycle(Object info) {
            AccessibilityWindowInfoCompatApi21.recycle((Object)info);
        }
    }

    private static class AccessibilityWindowInfoStubImpl
    implements AccessibilityWindowInfoImpl {
        private AccessibilityWindowInfoStubImpl() {
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(Object info) {
            return null;
        }

        @Override
        public int getType(Object info) {
            return -1;
        }

        @Override
        public int getLayer(Object info) {
            return -1;
        }

        @Override
        public Object getRoot(Object info) {
            return null;
        }

        @Override
        public Object getParent(Object info) {
            return null;
        }

        @Override
        public int getId(Object info) {
            return -1;
        }

        @Override
        public void getBoundsInScreen(Object info, Rect outBounds) {
        }

        @Override
        public boolean isActive(Object info) {
            return true;
        }

        @Override
        public boolean isFocused(Object info) {
            return true;
        }

        @Override
        public boolean isAccessibilityFocused(Object info) {
            return true;
        }

        @Override
        public int getChildCount(Object info) {
            return 0;
        }

        @Override
        public Object getChild(Object info, int index) {
            return null;
        }

        @Override
        public void recycle(Object info) {
        }
    }

    private static interface AccessibilityWindowInfoImpl {
        public Object obtain();

        public Object obtain(Object var1);

        public int getType(Object var1);

        public int getLayer(Object var1);

        public Object getRoot(Object var1);

        public Object getParent(Object var1);

        public int getId(Object var1);

        public void getBoundsInScreen(Object var1, Rect var2);

        public boolean isActive(Object var1);

        public boolean isFocused(Object var1);

        public boolean isAccessibilityFocused(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void recycle(Object var1);
    }
}

